/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.math;

import dev.toma.gunsrpg.util.object.LazyLoader;
import java.util.Random;
import java.util.function.ToIntFunction;

public class WeightedRandom<T> {
    protected static Random random = new Random();
    protected final T[] values;
    protected final ToIntFunction<T> toIntFunction;
    private final LazyLoader<Integer> totalValue;

    public WeightedRandom(ToIntFunction<T> toIntFunction, T[] values) {
        this.toIntFunction = toIntFunction;
        this.values = values;
        this.totalValue = new LazyLoader<Integer>(this::gatherAll);
    }

    public T getRandom() {
        int total = this.totalValue.get();
        int weight = random.nextInt(total);
        for (int idx = this.values.length - 1; idx >= 0; --idx) {
            T t = this.values[idx];
            if ((weight -= this.toIntFunction.applyAsInt(t)) >= 0) continue;
            return t;
        }
        return null;
    }

    public T[] getValues() {
        return this.values;
    }

    public int getValueCount() {
        return this.values.length;
    }

    private int gatherAll() {
        int i = 0;
        for (T t : this.values) {
            i += this.toIntFunction.applyAsInt(t);
        }
        return i;
    }
}

